/**
 * Node.js polyfills for browser environment
 * Required by WalletConnect and other Web3 libraries
 */
(function() {
    'use strict';

    // Polyfill process for Node.js compatibility
    if (typeof window.process === 'undefined') {
        window.process = {
            env: {},
            version: '',
            platform: 'browser',
            browser: true,
            nextTick: function(fn) {
                setTimeout(fn, 0);
            }
        };
    }

    // Polyfill global
    if (typeof window.global === 'undefined') {
        window.global = window;
    }

    // Basic Buffer polyfill (for simple use cases)
    if (typeof window.Buffer === 'undefined') {
        window.Buffer = {
            isBuffer: function() { return false; },
            from: function(data, encoding) {
                if (typeof data === 'string') {
                    if (encoding === 'hex') {
                        var result = new Uint8Array(data.length / 2);
                        for (var i = 0; i < data.length; i += 2) {
                            result[i / 2] = parseInt(data.substr(i, 2), 16);
                        }
                        return result;
                    }
                    return new TextEncoder().encode(data);
                }
                return new Uint8Array(data);
            },
            alloc: function(size) {
                return new Uint8Array(size);
            },
            concat: function(arrays) {
                var totalLength = arrays.reduce(function(acc, arr) { return acc + arr.length; }, 0);
                var result = new Uint8Array(totalLength);
                var offset = 0;
                arrays.forEach(function(arr) {
                    result.set(arr, offset);
                    offset += arr.length;
                });
                return result;
            }
        };
    }
})();
